

#include <cstdlib>
#include <cstdio>

#include "lcinterfacekit.h"

int CCONV Lcinterfacekit::InputChangeHandler(CPhidgetInterfaceKitHandle ifKit, void *usrptr, int Index, int State)
{
	int t_success;
	char * scmMsg;

	scmMsg=NULL;
	scmMsg = (char *)malloc(512);

	sprintf(scmMsg, "send \"%s %08x, %d, %d\" to current card", (char *)usrptr, ifKit, Index, State);
	SendCardMessage(scmMsg, &t_success);

	if (scmMsg != NULL)
		free(scmMsg);

	return 0;
}


int CCONV Lcinterfacekit::OutputChangeHandler(CPhidgetInterfaceKitHandle ifKit, void *usrptr, int Index, int State)
{
	int t_success;
	char * scmMsg;
	scmMsg=NULL;
	scmMsg = (char *)malloc(512);

	sprintf(scmMsg, "send \"%s %08x, %d, %d\" to current card", (char *)usrptr, ifKit, Index, State);
	SendCardMessage(scmMsg, &t_success);

	if (scmMsg != NULL)
		free(scmMsg);

	return 0;
}

int CCONV Lcinterfacekit::SensorChangeHandler(CPhidgetInterfaceKitHandle ifKit, void *usrptr, int Index, int Value)
{
	int t_success;

	char * scmMsg;
	scmMsg=NULL;
	scmMsg = (char *)malloc(512);

	sprintf(scmMsg, "send \"%s %08x, %d, %d\" to current card", (char *)usrptr, ifKit, Index, Value);
	SendCardMessage(scmMsg, &t_success);

	if (scmMsg != NULL)
		free(scmMsg);

	return 0;
}

void Lcinterfacekit::phidgetsInterfaceKit_set_OnInputChange_Handler(char *p_arguments[], int p_argument_count, char **r_result, Bool *r_pass, Bool *r_err)
{  
	CPhidgetInterfaceKitHandle ifKit = convertToAddr((p_arguments[0]), NULL, 16);		
	
	char* str=(char *)malloc(90);
	str=strdup(p_arguments[1]);
	
	int outcome=CPhidgetInterfaceKit_set_OnInputChange_Handler((CPhidgetInterfaceKitHandle)ifKit, &Lcinterfacekit::InputChangeHandler, str);
	
	returnOutcome(outcome, r_result, r_pass, r_err);
}


void Lcinterfacekit::phidgetsInterfaceKit_set_OnOutputChange_Handler(char *p_arguments[], int p_argument_count, char **r_result, Bool *r_pass, Bool *r_err)
{  
	CPhidgetInterfaceKitHandle ifKit = convertToAddr((p_arguments[0]), NULL, 16);		
	
	char* str=(char *)malloc(90);
	str=strdup(p_arguments[1]);
	
	int outcome=CPhidgetInterfaceKit_set_OnOutputChange_Handler((CPhidgetInterfaceKitHandle)ifKit, &Lcinterfacekit::OutputChangeHandler, str);
	
	returnOutcome(outcome, r_result, r_pass, r_err);
}


void Lcinterfacekit::phidgetsInterfaceKit_set_OnSensorChange_Handler(char *p_arguments[], int p_argument_count, char **r_result, Bool *r_pass, Bool *r_err)
{  
	CPhidgetInterfaceKitHandle ifKit = convertToAddr((p_arguments[0]), NULL, 16);		
	
	char* str=(char *)malloc(90);
	str=strdup(p_arguments[1]);
	
	int outcome=CPhidgetInterfaceKit_set_OnSensorChange_Handler((CPhidgetInterfaceKitHandle)ifKit, &Lcinterfacekit::SensorChangeHandler, str);
	
	returnOutcome(outcome, r_result, r_pass, r_err);
}


void Lcinterfacekit::phidgetsInterfaceKit_create(char *p_arguments[], int p_argument_count, char **r_result, Bool *r_pass, Bool *r_err)
{
	CPhidgetInterfaceKitHandle ifKit = convertToAddr((p_arguments[0]), NULL, 16);	
	
	int outcome=CPhidgetInterfaceKit_create(&ifKit);
	if(outcome==0){
		char str[90];
		int t_success;

		/* Converts to Hexadecimal format */
		sprintf(str,"%08x",ifKit);
  
		/* Lets Live Code see that the CPhidgetInterfaceKitHandle object has been created */
		SetVariable(p_arguments[0], str, &t_success);
	}
	returnOutcome(outcome, r_result, r_pass, r_err);
	return;
}

void Lcinterfacekit::phidgetsInterfaceKit_getInputCount(char *p_arguments[], int p_argument_count, char **r_result, Bool *r_pass, Bool *r_err)
{  
	CPhidgetInterfaceKitHandle ifKit = convertToAddr((p_arguments[0]), NULL, 16);		
	char str[90];
	int t_success, count;
	
	int outcome = CPhidgetInterfaceKit_getInputCount((CPhidgetInterfaceKitHandle)ifKit, &count);
	if(outcome==0){
		sprintf(str,"%d",count);
		SetVariable(p_arguments[1], str, &t_success);
	}
	returnOutcome(outcome, r_result, r_pass, r_err);
	return;
}

void Lcinterfacekit::phidgetsInterfaceKit_getInputState(char *p_arguments[], int p_argument_count, char **r_result, Bool *r_pass, Bool *r_err)
{  
	CPhidgetInterfaceKitHandle ifKit = convertToAddr((p_arguments[0]), NULL, 16);		
	char str[90];
	int t_success, inputState;
	
	int outcome = CPhidgetInterfaceKit_getInputState((CPhidgetInterfaceKitHandle)ifKit, atoi(p_arguments[1]), &inputState);
	if(outcome==0){
		sprintf(str,"%d",inputState);
		SetVariable(p_arguments[2], str, &t_success);
	}
	returnOutcome(outcome, r_result, r_pass, r_err);
	return;
}
 
void Lcinterfacekit::phidgetsInterfaceKit_getOutputCount(char *p_arguments[], int p_argument_count, char **r_result, Bool *r_pass, Bool *r_err)
{  
	CPhidgetInterfaceKitHandle ifKit = convertToAddr((p_arguments[0]), NULL, 16);		
	char str[90];
	int t_success, count;
	

	int outcome = CPhidgetInterfaceKit_getOutputCount((CPhidgetInterfaceKitHandle)ifKit, &count);
	if(outcome==0){
		sprintf(str,"%d",count);
		SetVariable(p_arguments[1], str, &t_success);
	}
	returnOutcome(outcome, r_result, r_pass, r_err);
	return;

}

void Lcinterfacekit::phidgetsInterfaceKit_getOutputState(char *p_arguments[], int p_argument_count, char **r_result, Bool *r_pass, Bool *r_err)
{  
	CPhidgetInterfaceKitHandle ifKit = convertToAddr((p_arguments[0]), NULL, 16);		
	char str[90];
	int t_success, count;
	
	int outcome = CPhidgetInterfaceKit_getOutputState((CPhidgetInterfaceKitHandle)ifKit, atoi(p_arguments[1]), &count);
	if(outcome==0){
		sprintf(str,"%d",count);
		SetVariable(p_arguments[2], str, &t_success);
	}
	returnOutcome(outcome, r_result, r_pass, r_err);
	return;

}


void Lcinterfacekit::phidgetsInterfaceKit_setOutputState(char *p_arguments[], int p_argument_count, char **r_result, Bool *r_pass, Bool *r_err)
{  
	CPhidgetInterfaceKitHandle ifKit = convertToAddr((p_arguments[0]), NULL, 16);		
	char str[90];
	int t_success;

	int outcome= CPhidgetInterfaceKit_setOutputState((CPhidgetInterfaceKitHandle)ifKit, atoi(p_arguments[1]), atoi(p_arguments[2]));
	returnOutcome(outcome, r_result, r_pass, r_err);
	return;

}

void Lcinterfacekit::phidgetsInterfaceKit_getSensorCount(char *p_arguments[], int p_argument_count, char **r_result, Bool *r_pass, Bool *r_err)
{  
	CPhidgetInterfaceKitHandle ifKit = convertToAddr((p_arguments[0]), NULL, 16);		
	char str[90];
	int t_success, count;
	
	int outcome = CPhidgetInterfaceKit_getSensorCount((CPhidgetInterfaceKitHandle)ifKit, &count);
	if(outcome==0){
		sprintf(str,"%d",count);
		SetVariable(p_arguments[1], str, &t_success);
	}
	returnOutcome(outcome, r_result, r_pass, r_err);
	return;

}

void Lcinterfacekit::phidgetsInterfaceKit_getSensorValue(char *p_arguments[], int p_argument_count, char **r_result, Bool *r_pass, Bool *r_err)
{  
	CPhidgetInterfaceKitHandle ifKit = convertToAddr((p_arguments[0]), NULL, 16);			
	char str[90];
	int t_success, sensorValue;

	int outcome= CPhidgetInterfaceKit_getSensorValue((CPhidgetInterfaceKitHandle)ifKit, atoi(p_arguments[1]), &sensorValue);
	if(outcome==0){
		sprintf(str,"%d",sensorValue);
		SetVariable(p_arguments[2], str, &t_success);
	}
	returnOutcome(outcome, r_result, r_pass, r_err);
	return;


}




void Lcinterfacekit::phidgetsInterfaceKit_getSensorRawValue(char *p_arguments[], int p_argument_count, char **r_result, Bool *r_pass, Bool *r_err)
{  
	CPhidgetInterfaceKitHandle ifKit = convertToAddr((p_arguments[0]), NULL, 16);		
	char str[90];
	int t_success, sensorRawValue;
	
	int outcome= CPhidgetInterfaceKit_getSensorRawValue((CPhidgetInterfaceKitHandle)ifKit, atoi(p_arguments[1]), &sensorRawValue);
	if(outcome==0){
		sprintf(str,"%d",sensorRawValue);
		SetVariable(p_arguments[2], str, &t_success);
	}
	returnOutcome(outcome, r_result, r_pass, r_err);
	return;


}

void Lcinterfacekit::phidgetsInterfaceKit_getSensorChangeTrigger(char *p_arguments[], int p_argument_count, char **r_result, Bool *r_pass, Bool *r_err)
{  
	CPhidgetInterfaceKitHandle ifKit = convertToAddr((p_arguments[0]), NULL, 16);		
	char str[90];
	int t_success, trigger;
	
	int outcome= CPhidgetInterfaceKit_getSensorChangeTrigger((CPhidgetInterfaceKitHandle)ifKit, atoi(p_arguments[1]), &trigger);
	if(outcome==0){
		sprintf(str,"%d",trigger);
		SetVariable(p_arguments[2], str, &t_success);
	}
	returnOutcome(outcome, r_result, r_pass, r_err);
	return;


}

void Lcinterfacekit::phidgetsInterfaceKit_setSensorChangeTrigger(char *p_arguments[], int p_argument_count, char **r_result, Bool *r_pass, Bool *r_err)
{  
	CPhidgetInterfaceKitHandle ifKit = convertToAddr((p_arguments[0]), NULL, 16);		

	int outcome= CPhidgetInterfaceKit_setSensorChangeTrigger((CPhidgetInterfaceKitHandle)ifKit, atoi(p_arguments[1]), atoi(p_arguments[2]));
	returnOutcome(outcome, r_result, r_pass, r_err);
	return;

}

void Lcinterfacekit::phidgetsInterfaceKit_getRatiometric(char *p_arguments[], int p_argument_count, char **r_result, Bool *r_pass, Bool *r_err)
{  
	CPhidgetInterfaceKitHandle ifKit = convertToAddr((p_arguments[0]), NULL, 16);		
	char str[90];
	int t_success, ratiometric;
	
	int outcome = CPhidgetInterfaceKit_getRatiometric((CPhidgetInterfaceKitHandle)ifKit, &ratiometric);
	if(outcome==0){
		sprintf(str,"%d",ratiometric);
		SetVariable(p_arguments[1], str, &t_success);
	}
	returnOutcome(outcome, r_result, r_pass, r_err);
	return;

}

void Lcinterfacekit::phidgetsInterfaceKit_setRatiometric(char *p_arguments[], int p_argument_count, char **r_result, Bool *r_pass, Bool *r_err)
{  
	CPhidgetInterfaceKitHandle ifKit = convertToAddr((p_arguments[0]), NULL, 16);		

	int outcome= CPhidgetInterfaceKit_setRatiometric((CPhidgetInterfaceKitHandle)ifKit, atoi(p_arguments[1]));
	returnOutcome(outcome, r_result, r_pass, r_err);
	return;

}


void Lcinterfacekit::phidgetsInterfaceKit_getDataRate(char *p_arguments[], int p_argument_count, char **r_result, Bool *r_pass, Bool *r_err)
{  
	CPhidgetInterfaceKitHandle ifKit = convertToAddr((p_arguments[0]), NULL, 16);		
	char str[90];
	int t_success, milliseconds;
	
	int outcome= CPhidgetInterfaceKit_getDataRate((CPhidgetInterfaceKitHandle)ifKit, atoi(p_arguments[1]), &milliseconds);
	if(outcome==0){
		sprintf(str,"%d",milliseconds);
		SetVariable(p_arguments[2], str, &t_success);
	}
	returnOutcome(outcome, r_result, r_pass, r_err);
	return;

}

void Lcinterfacekit::phidgetsInterfaceKit_setDataRate(char *p_arguments[], int p_argument_count, char **r_result, Bool *r_pass, Bool *r_err)
{  
	CPhidgetInterfaceKitHandle ifKit = convertToAddr((p_arguments[0]), NULL, 16);		
	
	int outcome= CPhidgetInterfaceKit_setDataRate((CPhidgetInterfaceKitHandle)ifKit, atoi(p_arguments[1]), atoi(p_arguments[2]));
	returnOutcome(outcome, r_result, r_pass, r_err);
	return;

}

void Lcinterfacekit::phidgetsInterfaceKit_getDataRateMin(char *p_arguments[], int p_argument_count, char **r_result, Bool *r_pass, Bool *r_err)
{  
	CPhidgetInterfaceKitHandle ifKit = convertToAddr((p_arguments[0]), NULL, 16);		
	char str[90];
	int t_success, max;
	
	int outcome= CPhidgetInterfaceKit_getDataRateMax((CPhidgetInterfaceKitHandle)ifKit, atoi(p_arguments[1]), &max);
	if(outcome==0){
		sprintf(str,"%d",max);
		SetVariable(p_arguments[2], str, &t_success);
	}
	returnOutcome(outcome, r_result, r_pass, r_err);
	return;

}

void Lcinterfacekit::phidgetsInterfaceKit_getDataRateMax(char *p_arguments[], int p_argument_count, char **r_result, Bool *r_pass, Bool *r_err)
{  
	CPhidgetInterfaceKitHandle ifKit = convertToAddr((p_arguments[0]), NULL, 16);		
	char str[90];
	int t_success, min;
	
	int outcome= CPhidgetInterfaceKit_getDataRateMin((CPhidgetInterfaceKitHandle)ifKit, atoi(p_arguments[1]), &min);
	if(outcome==0){
		sprintf(str,"%d",min);
		SetVariable(p_arguments[2], str, &t_success);
	}
	returnOutcome(outcome, r_result, r_pass, r_err);
	return;

}

 